/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.RedirPacket;
import com.ami.iusb.protocol.RedirProtocol;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class CDROMProtocol
extends RedirProtocol {
    @Override
    public int getDataLen(ByteBuffer inputBuffer) throws RedirProtocolException {
        IUSBHeader header = new IUSBHeader();
        try {
            header.read(inputBuffer);
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
        return (int)header.dataPacketLen;
    }

    @Override
    public RedirPacket getPacket(ByteBuffer inputBuffer) throws RedirProtocolException {
        IUSBSCSI packet;
        IUSBHeader header = new IUSBHeader();
        try {
            header.read(inputBuffer);
            packet = new IUSBSCSI(header);
            ((RedirPacket)packet).readData(inputBuffer);
        }
        catch (BufferUnderflowException e) {
            return null;
        }
        return packet;
    }
}

