/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.CDROMRedir;
import com.ami.iusb.FloppyRedir;
import com.ami.iusb.JListDialog;
import com.ami.iusb.RedirectionException;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public class IUSBRedirSession {
    JViewerApp app;
    private String host;
    public static final byte AUTH_SESS_TOKEN_PKT_SIZE = 18;
    public static final byte AUTH_USER_PKT_SIZE = 98;
    public static final byte AUTH_PKT_MAX_SIZE = 98;
    public CDROMRedir cdromSession;
    public FloppyRedir floppySession;
    public static final int DEVICE_REDIR_STATUS_IDLE = 0;
    public static final int DEVICE_REDIR_STATUS_CONNECTED = 1;
    public static final int DEVICE_REDIR_STATUS_TRANSFERING = 2;
    private int cdromRedirStatus = 0;
    private int floppyRedirStatus = 0;
    final int cdserver_port = 5120;
    final int fdserver_port = 5123;

    public IUSBRedirSession(JViewerApp app) {
        this.app = app;
        this.host = null;
        this.cdromSession = null;
        this.floppySession = null;
    }

    public boolean StartCDROMRedir(String host, int port, boolean secure, String session_token, String source_cdrom_path) {
        if (host == null) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_1_IUSBREDIR"));
            return false;
        }
        if (source_cdrom_path.length() == 0) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_2_IUSBREDIR"));
            return false;
        }
        try {
            if (this.cdromSession != null) {
                if (this.cdromSession.isRedirActive()) {
                    this.app.generalErrorMessage(LocaleStrings.GetString("6_3_IUSBREDIR"));
                    return false;
                }
                this.cdromSession = null;
                System.gc();
            }
            this.cdromSession = new CDROMRedir(true, this.app);
            Debug.out.println("CDROMRedir object created");
            if (!this.cdromSession.startRedirection(host, port, secure, session_token, source_cdrom_path)) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_4_IUSBREDIR"));
                this.StopCDROMRedir();
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_5_IUSBREDIR"));
            this.StopCDROMRedir();
            return false;
        }
        catch (RedirectionException e) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_6_IUSBREDIR") + e.getMessage());
            this.StopCDROMRedir();
            return false;
        }
        this.cdromRedirStatus = 1;
        return true;
    }

    public boolean StopCDROMRedir() {
        if (this.cdromSession != null) {
            if (!this.cdromSession.stopRedirection()) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_7_IUSBREDIR"));
                return false;
            }
            this.cdromSession = null;
            System.gc();
        }
        this.cdromRedirStatus = 0;
        return true;
    }

    public boolean StartISORedir(String host, int port, boolean secure, String session_token, String source_cdrom_path) {
        if (host == null) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_8_IUSBREDIR"));
            return false;
        }
        if (source_cdrom_path.length() == 0) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_9_IUSBREDIR"));
            return false;
        }
        try {
            if (this.cdromSession != null) {
                if (this.cdromSession.isRedirActive()) {
                    this.app.generalErrorMessage(LocaleStrings.GetString("6_10_IUSBREDIR"));
                    return false;
                }
                this.cdromSession = null;
                System.gc();
            }
            this.cdromSession = new CDROMRedir(false, this.app);
            if (!this.cdromSession.startRedirection(host, port, secure, session_token, source_cdrom_path)) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_11_IUSBREDIR"));
                this.StopISORedir();
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_12_IUSBREDIR"));
            this.StopISORedir();
            return false;
        }
        catch (RedirectionException e) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_13_IUSBREDIR") + e.getMessage());
            this.StopISORedir();
            return false;
        }
        this.cdromRedirStatus = 1;
        return true;
    }

    public boolean StopISORedir() {
        return this.StopCDROMRedir();
    }

    public boolean StartFloppyRedir(String host, int port, boolean secure, String session_token, String source_floppy_path) {
        if (host == null) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_14_IUSBREDIR"));
            return false;
        }
        if (source_floppy_path.length() == 0) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_15_IUSBREDIR"));
            return false;
        }
        try {
            if (this.floppySession != null) {
                if (this.floppySession.isRedirActive()) {
                    this.app.generalErrorMessage(LocaleStrings.GetString("6_16_IUSBREDIR"));
                    return false;
                }
                this.floppySession = null;
                System.gc();
            }
            this.floppySession = new FloppyRedir(true, this.app);
            if (!this.floppySession.startRedirection(host, port, secure, session_token, source_floppy_path)) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_17_IUSBREDIR"));
                this.StopFloppyRedir();
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_18_IUSBREDIR"));
            this.StopFloppyRedir();
            return false;
        }
        catch (RedirectionException e) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_19_IUSBREDIR") + e.getMessage());
            this.StopFloppyRedir();
            return false;
        }
        this.floppyRedirStatus = 1;
        return true;
    }

    public boolean StopFloppyRedir() {
        if (this.floppySession != null) {
            if (!this.floppySession.stopRedirection()) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_20_IUSBREDIR"));
                return false;
            }
            this.floppySession = null;
            System.gc();
        }
        this.floppyRedirStatus = 0;
        return true;
    }

    public boolean sendTransferCmdCDROM() {
        if (this.cdromSession == null) {
            return false;
        }
        try {
            this.cdromSession.sendTransferCmd();
        }
        catch (RedirectionException e) {
            Debug.out.println("Exception while sending Transfer cmd to cdserver");
            return false;
        }
        catch (IOException e) {
            Debug.out.println("Exception while sending Transfer cmd to cdserver");
            return false;
        }
        this.cdromRedirStatus = 2;
        return true;
    }

    public boolean sendTransferCmdFloppy() {
        if (this.floppySession == null) {
            return false;
        }
        try {
            this.floppySession.sendTransferCmd();
        }
        catch (RedirectionException e) {
            Debug.out.println("Exception while sending Transfer cmd to fdserver");
            return false;
        }
        catch (IOException e) {
            Debug.out.println("Exception while sending Transfer cmd to fdserver");
            return false;
        }
        this.floppyRedirStatus = 2;
        return true;
    }

    public boolean StartFloppyImageRedir(String host, int port, boolean secure, String session_token, String source_floppy_path) {
        if (host == null) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_21_IUSBREDIR"));
            return false;
        }
        if (source_floppy_path.length() == 0) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_22_IUSBREDIR"));
            return false;
        }
        try {
            if (this.floppySession != null) {
                if (this.floppySession.isRedirActive()) {
                    this.app.generalErrorMessage(LocaleStrings.GetString("6_23_IUSBREDIR"));
                    return false;
                }
                this.floppySession = null;
                System.gc();
            }
            this.floppySession = new FloppyRedir(false, this.app);
            if (!this.floppySession.startRedirection(host, port, secure, session_token, source_floppy_path)) {
                this.app.generalErrorMessage(LocaleStrings.GetString("6_24_IUSBREDIR"));
                this.StopFloppyImageRedir();
                return false;
            }
        }
        catch (UnsatisfiedLinkError e) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_25_IUSBREDIR"));
            this.StopFloppyImageRedir();
            return false;
        }
        catch (RedirectionException e) {
            this.app.generalErrorMessage(LocaleStrings.GetString("6_26_IUSBREDIR") + e.getMessage());
            this.StopFloppyImageRedir();
            return false;
        }
        this.floppyRedirStatus = 1;
        return true;
    }

    public boolean StopFloppyImageRedir() {
        return this.StopFloppyRedir();
    }

    public String getLIBCDROMVersion() {
        String version;
        try {
            if (this.cdromSession == null) {
                this.cdromSession = new CDROMRedir(false, this.app);
                version = this.cdromSession.getLIBCDROMVersion();
                this.cdromSession = null;
                System.gc();
            } else {
                version = this.cdromSession.getLIBCDROMVersion();
            }
        }
        catch (UnsatisfiedLinkError e) {
            version = "Not present";
        }
        return version;
    }

    public String promptCDROM(String[] cdromList) {
        JFrame frame = this.app.getFrame();
        return (String)JListDialog.showDialog(frame, frame, LocaleStrings.GetString("6_27_IUSBREDIR"), LocaleStrings.GetString("6_28_IUSBREDIR"), cdromList, null);
    }

    public String isoImageSelector() {
        JFrame frame = this.app.getFrame();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new IsoImageFilter());
        if (chooser.showOpenDialog(frame) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public String getLIBFLOPPYVersion() {
        String version;
        try {
            if (this.floppySession == null) {
                this.floppySession = new FloppyRedir(false, this.app);
                version = this.floppySession.getLIBFLOPPYVersion();
                this.floppySession = null;
                System.gc();
            } else {
                version = this.floppySession.getLIBFLOPPYVersion();
            }
        }
        catch (UnsatisfiedLinkError e) {
            version = "Not present";
        }
        return version;
    }

    public String promptFloppy(String[] floppyList) {
        JFrame mainFrame = this.app.getFrame();
        return (String)JListDialog.showDialog(mainFrame, mainFrame, LocaleStrings.GetString("6_29_IUSBREDIR"), LocaleStrings.GetString("6_30_IUSBREDIR"), LocaleStrings.GetString("6_31_IUSBREDIR"), floppyList, null);
    }

    public String floppyImageSelector() {
        JFrame mainFrame = this.app.getFrame();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FloppyImageFilter());
        if (chooser.showOpenDialog(mainFrame) == 0) {
            return chooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public int getCDROMRedirStatus() {
        return this.cdromRedirStatus;
    }

    public int getFloppyRedirStatus() {
        return this.floppyRedirStatus;
    }

    public String getCDROMSource() {
        if (this.cdromSession != null) {
            return this.cdromSession.getSourceDrive();
        }
        return new String("");
    }

    public String getFloppySource() {
        if (this.floppySession != null) {
            return this.floppySession.getSourceDrive();
        }
        return new String("");
    }

    public void stopCDROMAbnormal() {
        this.cdromSession = null;
        System.gc();
        this.cdromRedirStatus = 0;
    }

    public void stopFloppyAbnormal() {
        this.floppySession = null;
        System.gc();
        this.floppyRedirStatus = 0;
    }

    public int getCDROMReadBytes() {
        if (this.cdromSession != null) {
            return this.cdromSession.getBytesRedirected();
        }
        return 0;
    }

    public int getFloppyReadBytes() {
        if (this.floppySession != null) {
            return this.floppySession.getBytesRedirected();
        }
        return 0;
    }

    public boolean simpleStartCDROMRedir(String host, String session_token, String source_cdrom_path) {
        return this.StartCDROMRedir(host, 5120, false, session_token, source_cdrom_path);
    }

    public boolean simpleStartISORedir(String host, String session_token, String source_cdrom_path) {
        return this.StartISORedir(host, 5120, false, session_token, source_cdrom_path);
    }

    public boolean simpleStartFloppyRedir(String host, String session_token, String source_floppy_path) {
        return this.StartFloppyRedir(host, 5123, false, session_token, source_floppy_path);
    }

    public boolean simpleStartFloppyImageRedir(String host, String session_token, String source_floppy_path) {
        return this.StartFloppyImageRedir(host, 5123, false, session_token, source_floppy_path);
    }

    class FloppyImageFilter
    extends FileFilter {
        FloppyImageFilter() {
        }

        @Override
        public boolean accept(File f) {
            String filename = f.getName();
            return filename.endsWith(".img") || filename.endsWith(".IMG") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.img";
        }
    }

    class IsoImageFilter
    extends FileFilter {
        IsoImageFilter() {
        }

        @Override
        public boolean accept(File f) {
            String filename = f.getName();
            return filename.endsWith(".iso") || filename.endsWith(".ISO") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.iso";
        }
    }
}

